﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class HorizontalMovement : MonoBehaviour {

    public float rangeMax = 10;
    public float direction = 1;
    public float speed = 3;
    public float initialPositionX;
	// Use this for initialization
	void Start () {
        initialPositionX = this.transform.position.x;
	}
	
	// Update is called once per frame
	void Update () {
        this.transform.position = new Vector2(this.transform.position.x + 
            (direction * Time.deltaTime * speed), this.transform.position.y);

        if (this.transform.position.x > initialPositionX + rangeMax)
        {
            direction = -1; //promenice pravac kretanja ako dodje do rangeMax
        }
        if (this.transform.position.x < initialPositionX - rangeMax)
        {
            direction = 1;
        }
	}
}
